<#ibiztemplate>
TARGET=PSDESERVICEAPI
</#ibiztemplate>
<#comment>不发布子系统实体</#comment>
<#if de.isSubSysDE()==false>
<#--  SYSAPI为RESTFUL，主从接口（非嵌套）  -->
<#if api.getAPIType() == "RESTFUL" && !item.isNested()>
<#assign pubPkgCodeName = pub.getPKGCodeName()>
<#assign itemCodeName = item.getCodeName()>
<#assign itemCodeNameLC = itemCodeName?lower_case>
<#assign deCodeName = de.getCodeName()>
<#assign deCodeNameLC = deCodeName?lower_case>

<#assign dePKCodeNameLC = srfcaseformat(de.getKeyPSDEField().getCodeName(),'l_u2lC')>
<#assign dePKCodeName = (dePKCodeNameLC)?cap_first>
<#assign deModelCodeNameLC = de.getPSSystemModule().getCodeName()?lower_case>
<#assign itemSysApiCodeName = item.getPSSysServiceAPI().getCodeName()>
<#assign itemSysApiCodeNameLC = item.getPSSysServiceAPI().getCodeName()?lower_case>
<#assign keyCNLC = "_id">
<#assign deStorageMode="None">
<#if de.getStorageMode()==1><#assign deStorageMode="Sql"><#elseif de.getStorageMode()==2><#assign deStorageMode="NoSQL"><#elseif de.getStorageMode()==4><#assign deStorageMode="ServiceApi"></#if>
package ${pubPkgCodeName}.${itemSysApiCodeNameLC}.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
<#if de.getStorageMode()==4><#else>import org.springframework.transaction.annotation.Transactional;</#if>
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import ${pubPkgCodeName}.${itemSysApiCodeNameLC}.dto.*;
import ${pubPkgCodeName}.${itemSysApiCodeNameLC}.mapping.*;
import ${pubPkgCodeName}.core.${deModelCodeNameLC}.domain.${deCodeName};
import ${pubPkgCodeName}.core.${deModelCodeNameLC}.service.I${deCodeName}Service;
import ${pubPkgCodeName}.core.${deModelCodeNameLC}.filter.${deCodeName}SearchContext;



<#if item.getPSDEServiceAPIRSs()??>
  <#list item.getPSDEServiceAPIRSs() as apider>
    <#assign deapide=apider.getMinorPSDEServiceAPI().getPSDataEntity()>
    <#assign deapideCN=deapide.getCodeName()>
    <#assign deapideModuleCNLC=deapide.getPSSystemModule().getCodeName()?lower_case>
    <#if apider.getMinorPSDEServiceAPI().isNested()  && (deapide.getStorageMode()==1||deapide.getStorageMode()==2||deapide.getStorageMode()==4) >
import ${pubPkgCodeName}.core.${deapideModuleCNLC}.filter.${deapideCN}SearchContext;
import ${pubPkgCodeName}.core.${deapideModuleCNLC}.domain.${deapideCN};
import ${pubPkgCodeName}.core.${deapideModuleCNLC}.service.I${deapideCN}Service;
    </#if>
  </#list>
</#if>

@Slf4j
@Api(tags = {"${itemCodeName}" })
<#comment>两个服务接口引用同一个实体时，会产生两个Resource，通过dev模式代理启动两个服务时，会产生bean同名冲突，所以需要进行区分</#comment>
@RestController("${itemSysApiCodeName}-${itemCodeName?lower_case}")
@RequestMapping("")
public class ${itemCodeName}Resource {

    @Autowired
    private I${deCodeName}Service ${deCodeNameLC}Service;

    @Autowired
    @Lazy
    private ${itemCodeName}Mapping ${itemCodeNameLC}Mapping;

<#--  嵌套服务对象  -->
<#if item.getPSDEServiceAPIRSs()??>
  <#list item.getPSDEServiceAPIRSs() as apider>
    <#assign deapide=apider.getMinorPSDEServiceAPI().getPSDataEntity()>
    <#assign deapideCN=deapide.getCodeName()>
    <#assign deapideModuleCNLC=deapide.getPSSystemModule().getCodeName()?lower_case>
    <#if apider.getMinorPSDEServiceAPI().isNested() && (deapide.getStorageMode()==1||deapide.getStorageMode()==2||deapide.getStorageMode()==4)>
    @Autowired
    private I${deapideCN}Service ${deapideCN?lower_case}Service;


    </#if>
  </#list>
</#if>
<#--  主接口  start -->
<#if item.isMajor()>
<#--<#assign parentPath = "/" + item.getPSSysServiceAPI().getCodeName()?lower_case  >-->
<#--<#assign selfPath="/" + srfpluralize(itemCodeNameLC) >-->
<#assign parentPath = ""  >
<#assign selfPath= "/" +srfpluralize(itemCodeNameLC) >
<#assign parentParams = "">
<#assign parentSearchParams = "" >
<#assign parentParams2 = "">
<#assign parentParams3 = "">
<#assign idParams = "">
<#assign idParams2 = "">
<#assign idParams3 = "">
<#assign etParams = "">
<#assign etParamsList = "">
<#assign etParams2 = "">
<#assign etParams3 = "">
<#assign id_etParams = "">
<#assign id_etParams4 = "">
<#assign id_etParams4_batch = "">

<#assign etParams = etParams + "@RequestBody " + itemCodeName + "DTO " + itemCodeNameLC + "dto">
<#assign etParamsList = etParamsList + "@RequestBody List<" + itemCodeName + "DTO> " + itemCodeNameLC + "dtos">
<#assign etParams2 = etParams2 +  itemCodeName + "DTO " + itemCodeNameLC + "dto">
<#assign etParams3 = etParams3 +  itemCodeNameLC + "dto">
<#assign idParams = idParams + "@PathVariable(\"" + itemCodeNameLC + keyCNLC + "\") " + srfjavatype(de.getKeyPSDEField().getStdDataType()) + " " + itemCodeNameLC + keyCNLC >
<#assign idParams2 = idParams2 + " " + srfjavatype(de.getKeyPSDEField().getStdDataType()) + " " + itemCodeNameLC + keyCNLC >
<#assign idParams3 = idParams3 + " " + itemCodeNameLC + keyCNLC >
<#assign id_etParams = id_etParams + "@PathVariable(\"" + itemCodeNameLC + keyCNLC + "\") " + srfjavatype(de.getKeyPSDEField().getStdDataType())+" " + itemCodeNameLC + keyCNLC + ", @RequestBody " + itemCodeName + "DTO " + itemCodeNameLC + "dto" >
<#assign id_etParams4 = id_etParams4 + "@RequestBody " + itemCodeName + "DTO " + itemCodeNameLC + "dto" >
<#assign id_etParams4_batch = id_etParams4_batch + "@RequestBody List<" + itemCodeName + "DTO> " + itemCodeNameLC + "dtos" >
<#assign fullPath = parentPath + selfPath>
    <#if item.getPSDEServiceAPIMethods()??>
        <#list item.getPSDEServiceAPIMethods() as apiMethod>
            <#assign reqMtd = apiMethod.getRequestMethod()>
            <#assign statusCode = "">
            <#if reqMtd == "POST" >
                <#assign statusCode = "HttpStatus.CREATED" >
            <#else>
                <#assign statusCode = "HttpStatus.OK" >
            </#if>
            <#if apiMethod.getActionType()=='DEACTION'>
                <#assign deaction = apiMethod.getPSDEAction()>
                <#assign deactionName = deaction.getName()>
                <#assign deactionCodeName = deaction.getCodeName()>



                <#if deaction.codeName?lower_case == 'create'>
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'${deStorageMode}'})")
    @ApiOperation(value = "${deaction.getLogicName()}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}")
	@RequestMapping(method = RequestMethod.POST, value = "${fullPath}")
<#if de.getStorageMode()==4><#else>    @Transactional</#if>
    public ResponseEntity<${itemCodeName}DTO> create(${etParams}) {
        ${deCodeName} domain = ${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dto);
		${deCodeNameLC}Service.create(domain);
        ${itemCodeName}DTO dto = ${itemCodeNameLC}Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'${deStorageMode}'})")
    @ApiOperation(value = "createBatch", tags = {"${itemCodeName}" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "${fullPath}/batch")
    public ResponseEntity<Boolean> createBatch(${etParamsList}) {
        ${deCodeNameLC}Service.createBatch(${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

                <#elseif deaction.codeName?lower_case == 'update'>
    @PreAuthorize("hasPermission(#${itemCodeNameLC + keyCNLC},'Update',{this.getEntity(),'${deStorageMode}'})")
    @ApiOperation(value = "${deaction.getLogicName()}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}")
	@RequestMapping(method = RequestMethod.PUT, value = "${fullPath}/{${itemCodeNameLC + keyCNLC}}")
<#if de.getStorageMode()==4><#else>    @Transactional</#if>
    public ResponseEntity<${itemCodeName}DTO> update(${id_etParams}) {
		${deCodeName} domain = ${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dto);
        domain.set${dePKCodeName}(${itemCodeNameLC + keyCNLC});
		${deCodeNameLC}Service.update(domain);
		${itemCodeName}DTO dto = ${itemCodeNameLC}Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#${itemCodeNameLC + keyCNLC},'Update',{this.getEntity(),'${deStorageMode}'})")
    @ApiOperation(value = "UpdateBatch", tags = {"${itemCodeName}" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "${fullPath}/batch")
    public ResponseEntity<Boolean> updateBatch(${etParamsList}) {
        ${deCodeNameLC}Service.updateBatch(${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

                <#elseif deaction.codeName?lower_case == 'save'>
    @ApiOperation(value = "${deaction.getLogicName()}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}")
	@RequestMapping(method = RequestMethod.${reqMtd}, value = "${fullPath}/${deactionCodeName?lower_case}")
    public ResponseEntity<Boolean> save(${etParams}) {
        return ResponseEntity.status(HttpStatus.OK).body(${deCodeNameLC}Service.save(${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"${itemCodeName}" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "${fullPath}/savebatch")
    public ResponseEntity<Boolean> saveBatch(${etParamsList}) {
        ${deCodeNameLC}Service.saveBatch(${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

                <#elseif deaction.codeName?lower_case == 'remove'>
    @PreAuthorize("hasPermission('Remove',{#${itemCodeNameLC + keyCNLC},{this.getEntity(),'${deStorageMode}'}})")
    @ApiOperation(value = "${deaction.getLogicName()}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}")
	@RequestMapping(method = RequestMethod.DELETE, value = "${fullPath}/{${itemCodeNameLC + keyCNLC}}")
<#if de.getStorageMode()==4><#else>    @Transactional</#if>
    public ResponseEntity<Boolean> remove(${idParams}) {
         return ResponseEntity.status(HttpStatus.OK).body(${deCodeNameLC}Service.remove(${itemCodeNameLC + keyCNLC}));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"${itemCodeName}" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "${fullPath}/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<${srfjavatype(de.getKeyPSDEField().getStdDataType())}> ids) {
        ${deCodeNameLC}Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

                <#elseif deaction.codeName?lower_case == 'get'>
    @PreAuthorize("hasPermission(#${itemCodeNameLC + keyCNLC},'Get',{this.getEntity(),'${deStorageMode}'})")
    @ApiOperation(value = "${deaction.getLogicName()}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}")
	@RequestMapping(method = RequestMethod.GET, value = "${fullPath}/{${itemCodeNameLC + keyCNLC}}")
    public ResponseEntity<${itemCodeName}DTO> get(${idParams}) {
        ${deCodeName} domain = ${deCodeNameLC}Service.get(${itemCodeNameLC + keyCNLC});
        ${itemCodeName}DTO dto = ${itemCodeNameLC}Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

               <#elseif deaction.codeName?lower_case == 'checkkey'>
    @ApiOperation(value = "${deaction.getLogicName()}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}")
	@RequestMapping(method = RequestMethod.${reqMtd}, value = "${fullPath}/${deactionCodeName?lower_case}")
    public ResponseEntity<Boolean> checkKey(${etParams}) {
        return  ResponseEntity.status(HttpStatus.OK).body(${deCodeNameLC}Service.checkKey(${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dto)));
    }

                <#elseif deaction.codeName?lower_case == 'getdraft'><#comment>前端支持临时模式，后台不做处理</#comment>
    @ApiOperation(value = "${deaction.getLogicName()}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}")
	@RequestMapping(method = RequestMethod.${reqMtd}, value = "${fullPath}/${deactionCodeName?lower_case}")
    public ResponseEntity<${itemCodeName}DTO> ${deactionCodeName?uncap_first}() {
        return ResponseEntity.status(HttpStatus.OK).body(${itemCodeNameLC}Mapping.toDto(${deCodeNameLC}Service.getDraft(new ${deCodeName}())));
    }

               <#elseif deaction.codeName?lower_case == 'createbatch'>
               <#elseif deaction.codeName?lower_case == 'updatebatch'>
               <#elseif deaction.codeName?lower_case == 'removebatch'>
               <#elseif deaction.codeName?lower_case == 'savebatch'>
               <#elseif deaction.getUserTag()?? && deaction.getActionType()?? && deaction.getUserTag() == 'REGIST' && deaction.getActionType() == 'USERCREATE'>

               <#else>
    @ApiOperation(value = "${deaction.getLogicName()}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}")
	@RequestMapping(method = RequestMethod.${reqMtd}, value = "${fullPath}/{${itemCodeNameLC + keyCNLC}}/${deactionCodeName?lower_case}")
<#if de.getStorageMode()==4><#else>    @Transactional</#if>
    public ResponseEntity<${itemCodeName}DTO> ${deactionCodeName?uncap_first}(${id_etParams}) {
        ${deCodeName} ${deCodeNameLC} = ${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dto);
        ${deCodeNameLC} = ${deCodeNameLC}Service.${srfmethodname(deactionCodeName)}(${deCodeNameLC});
        ${itemCodeNameLC}dto = ${itemCodeNameLC}Mapping.toDto(${deCodeNameLC});
        return ResponseEntity.status(HttpStatus.OK).body(${itemCodeNameLC}dto);
    }

                </#if>
            <#elseif apiMethod.getActionType()=='FETCH'>
                <#assign deds = apiMethod.getPSDEDataSet()>
    @PreAuthorize("hasPermission('Get',{#context,'${deds.getCodeName()}',this.getEntity(),'${deStorageMode}'})")
	@ApiOperation(value = "fetch${deds.getLogicName()}", tags = {"${itemCodeName}" } ,notes = "fetch${deds.getLogicName()}")
    @RequestMapping(method= RequestMethod.${reqMtd} , value="${fullPath}/fetch<#if (deds.getName()=='DEFAULT')>${deds.getCodeName()?lower_case}<#else>${deds.getCodeName()?lower_case}</#if>")
	public ResponseEntity<List<<#if deds.isEnableGroup()>HashMap<#else>${itemCodeName}DTO</#if>>> fetch<#if (deds.getName()=='DEFAULT')>${deds.getCodeName()}<#else>${deds.getCodeName()}</#if>(${deCodeName}SearchContext context) {
        <#--${parentSearchParams}-->
        <#if deds.isEnableGroup()>
        Page<HashMap> domains = ${deCodeNameLC}Service.search${deds.getCodeName()}(context) ;
        return ResponseEntity.status(${statusCode})
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
        <#else>
        Page<${deCodeName}> domains = ${deCodeNameLC}Service.search${deds.getCodeName()}(context) ;
        List<${itemCodeName}DTO> list = ${itemCodeNameLC}Mapping.toDto(domains.getContent());
        return ResponseEntity.status(${statusCode})
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
        </#if>
	}

    @PreAuthorize("hasPermission('Get',{#context,'${deds.getCodeName()}',this.getEntity(),'${deStorageMode}'})")
	@ApiOperation(value = "search${deds.getLogicName()}", tags = {"${itemCodeName}" } ,notes = "search${deds.getLogicName()}")
    @RequestMapping(method= RequestMethod.${reqMtd} , value="${fullPath}/search<#if (deds.getName()=='DEFAULT')>${deds.getCodeName()?lower_case}<#else>${deds.getCodeName()?lower_case}</#if>")
	public ResponseEntity<Page<<#if deds.isEnableGroup()>HashMap<#else>${itemCodeName}DTO</#if>>> search<#if (deds.getName()=='DEFAULT')>${deds.getCodeName()}<#else>${deds.getCodeName()}</#if>(${deCodeName}SearchContext context) {
        <#--${parentSearchParams}-->
        <#if deds.isEnableGroup()>
        Page<HashMap> domains = ${deCodeNameLC}Service.search${deds.getCodeName()}(context) ;
	    return ResponseEntity.status(${statusCode})
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
        <#else>
        Page<${deCodeName}> domains = ${deCodeNameLC}Service.search${deds.getCodeName()}(context) ;
	    return ResponseEntity.status(${statusCode})
                .body(new PageImpl(${itemCodeNameLC}Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
        </#if>
	}

            </#if>
        </#list>
    </#if>
</#if>
<#--  主接口  end -->

<#--  关系接口  start  -->
<#if item.getPSDEServiceAPIRSPathCount() gt 0>
  <#list 0..1000 as x>
    <#if x gte item.getPSDEServiceAPIRSPathCount()>
      <#break>
    <#else>
        <#assign parentPath = "">
        <#assign selfPath="/" + srfpluralize(itemCodeNameLC) >
        <#assign parentParams = "">
        <#assign byParams = "By">
        <#assign parentSearchParams = "" >
        <#assign parentSetParams = "" >
        <#assign parentParams2 = "">
        <#assign parentParams3 = "">
        <#assign idParams = "">
        <#assign idParams2 = "">
        <#assign idParams3 = "">
        <#assign etParams = "">
        <#assign etParamsList = "">
        <#assign etParams2 = "">
        <#assign etParams3 = "">
        <#assign id_etParams = "">
        <#assign id_etParams4 = "">
        <#assign id_etParams4_batch = "">
        <#assign apiRsPathLast = item.getPSDEServiceAPIRSPathLast(x)>
	  <#list item.getPSDEServiceAPIRSPath(x) as rs>
        <#assign rsMainDEServiceAPI = rs.getMajorPSDEServiceAPI()>
        <#assign rsMainDe = rsMainDEServiceAPI.getPSDataEntity()>
        <#assign rsMainDeCN = rsMainDe.codeName >
        <#assign rsMainDeCNLC = rsMainDeCN?lower_case >
        <#assign rsMainDePKCN = rsMainDe.getKeyPSDEField().codeName >
        <#assign rsMainDePKCNLC = rsMainDePKCN?lower_case >
        <#assign rsMainDePKDataType = rsMainDe.getKeyPSDEField().getStdDataType() >
        <#assign parentPath += "/" + srfpluralize(rsMainDEServiceAPI.codeName)?lower_case + "/{" + rsMainDeCNLC + keyCNLC + "}" >
        <#if rs_index != 0 && parentParams!= "">
          <#assign parentParams += ", ">
        </#if>
        <#assign parentParams += "@PathVariable(\"" + rsMainDeCNLC + keyCNLC + "\") " + srfjavatype(rsMainDePKDataType) +  " " + rsMainDeCNLC + keyCNLC >
        <#assign byParams += rsMainDeCN >
      <#if rs.getPSDER1N()?? && apiRsPathLast.getCodeName() == rs.getCodeName()>
          <#assign parentSearchParams += "context.setN_" + rs.getPSDER1N().getPSPickupDEField().getName()?lower_case + "_eq("+ rsMainDeCNLC + keyCNLC +");" >
          <#assign parentSetParams += "domain.set" + srfcaseformat(rs.getPSDER1N().getPSPickupDEField().getCodeName(),'l_u2lC')?cap_first + "("+ rsMainDeCNLC + keyCNLC +");" >

        </#if>
        <#assign parentParams2 += "" + srfjavatype(rsMainDePKDataType)+" " + rsMainDeCNLC + keyCNLC >
        <#assign parentParams3 += "" + rsMainDeCNLC + keyCNLC >

      </#list>
      <#if parentParams != "" >
          <#assign idParams = parentParams + ", ">
          <#assign idParams2 = parentParams2 + ", ">
          <#assign idParams3 = parentParams3 + ", ">
          <#assign etParams = parentParams + ", ">
          <#assign etParamsList = parentParams + ", ">
          <#assign etParams2 = parentParams2 + ", ">
          <#assign etParams3 = parentParams3 + ", ">
          <#assign id_etParams = parentParams + ", ">
          <#assign id_etParams4 = parentParams + ", ">
          <#assign id_etParams4_batch = parentParams + ", ">
        </#if>
        <#assign etParams = etParams + "@RequestBody " + itemCodeName + "DTO " + itemCodeNameLC + "dto">
        <#assign etParamsList = etParamsList + "@RequestBody List<" + itemCodeName + "DTO> " + itemCodeNameLC + "dtos">
        <#assign etParams2 = etParams2 +  itemCodeName + "DTO " + itemCodeNameLC + "dto">
        <#assign etParams3 = etParams3 +  itemCodeNameLC + "dto">
        <#assign idParams = idParams + "@PathVariable(\"" + itemCodeNameLC + keyCNLC + "\") " + srfjavatype(de.getKeyPSDEField().getStdDataType()) + " " + itemCodeNameLC + keyCNLC >
        <#assign idParams2 = idParams2 + " " + srfjavatype(de.getKeyPSDEField().getStdDataType()) + " " + itemCodeNameLC + keyCNLC >
        <#assign idParams3 = idParams3 + " " + itemCodeNameLC + keyCNLC >
        <#assign id_etParams = id_etParams + "@PathVariable(\"" + itemCodeNameLC + keyCNLC + "\") " + srfjavatype(de.getKeyPSDEField().getStdDataType())+" " + itemCodeNameLC + keyCNLC + ", @RequestBody " + itemCodeName + "DTO " + itemCodeNameLC + "dto" >
        <#assign id_etParams4 = id_etParams4 + "@RequestBody " + itemCodeName + "DTO " + itemCodeNameLC + "dto" >
        <#assign id_etParams4_batch = id_etParams4_batch + "@RequestBody List<" + itemCodeName + "DTO> " + itemCodeNameLC + "dtos" >
        <#assign fullPath = parentPath + selfPath>
      <#if item.getPSDEServiceAPIMethods()??>
        <#list item.getPSDEServiceAPIMethods() as apiMethod>
            <#assign reqMtd = apiMethod.getRequestMethod()>
            <#assign statusCode = "">
            <#if reqMtd == "POST" >
                <#assign statusCode = "HttpStatus.CREATED" >
            <#else>
                <#assign statusCode = "HttpStatus.OK" >
            </#if>
            <#if apiMethod.getActionType()=='DEACTION'>
                <#assign deaction = apiMethod.getPSDEAction()>
                <#assign deactionName = deaction.getName()>
                <#assign deactionCodeName = deaction.getCodeName()>
                <#if deaction.codeName?lower_case == 'create'>
    @ApiOperation(value = "${deaction.getLogicName()}${byParams}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}${byParams}")
	@RequestMapping(method = RequestMethod.POST, value = "${fullPath}")
<#if de.getStorageMode()==4><#else>    @Transactional</#if>
    public ResponseEntity<${itemCodeName}DTO> ${deactionCodeName?uncap_first}${byParams}(${etParams}) {
        ${deCodeName} domain = ${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dto);
        ${parentSetParams}
		${deCodeNameLC}Service.create(domain);
        ${itemCodeName}DTO dto = ${itemCodeNameLC}Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatch${byParams}", tags = {"${itemCodeName}" },  notes = "createBatch${byParams}")
	@RequestMapping(method = RequestMethod.POST, value = "${fullPath}/batch")
    public ResponseEntity<Boolean> createBatch${byParams}(${etParamsList}) {
        List<${deCodeName}> domainlist=${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dtos);
        for(${deCodeName} domain:domainlist){
            ${parentSetParams}
        }
        ${deCodeNameLC}Service.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

                <#elseif deaction.codeName?lower_case == 'update'>
    @ApiOperation(value = "${deaction.getLogicName()}${byParams}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}${byParams}")
	@RequestMapping(method = RequestMethod.PUT, value = "${fullPath}/{${itemCodeNameLC + keyCNLC}}")
<#if de.getStorageMode()==4><#else>    @Transactional</#if>
    public ResponseEntity<${itemCodeName}DTO> ${deactionCodeName?uncap_first}${byParams}(${id_etParams}) {
        ${deCodeName} domain = ${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dto);
        ${parentSetParams}
        domain.set${dePKCodeName}(${itemCodeNameLC + keyCNLC});
		${deCodeNameLC}Service.update(domain);
        ${itemCodeName}DTO dto = ${itemCodeNameLC}Mapping.toDto(domain);
        <#--
                    <#if item.getPSDEServiceAPIRSs()??>
                        <#list item.getPSDEServiceAPIRSs() as apider>
                            <#assign deMinApi = apider.getMinorPSDEServiceAPI()>
                            <#assign deMinApiCN = deMinApi.getCodeName()>
                            <#assign deMinApiCNLC = deMinApi.getCodeName()?lower_case>
                            <#assign deapide=deMinApi.getPSDataEntity()>
                            <#if deMinApi.isNested()>
                                <#assign subDTOs = srfpluralize(deMinApiCN)?lower_case >
		List<${deMinApiCN}DTO> ${deMinApiCNLC}dtos = ${itemCodeNameLC}dto.get${subDTOs?cap_first}();
		Page<${deapide.getCodeName()}> ${deMinApiCNLC}DOs = ${deapide.getCodeName()?lower_case}Service.selectBy${apider.getPSDER1N().getCodeName()}(${itemCodeNameLC + keyCNLC});
        List<${srfjavatype(deapide.getKeyPSDEField().getStdDataType())}> ${deMinApiCNLC}Ids = new ArrayList<${srfjavatype(deapide.getKeyPSDEField().getStdDataType())}>();
        if (${deMinApiCNLC}DOs != null && !${deMinApiCNLC}DOs.isEmpty()) {
            for (${deapide.getCodeName()} minorDO : ${deMinApiCNLC}DOs) {
                ${deMinApiCNLC}Ids.add(minorDO.get${deapide.getKeyPSDEField().getCodeName()?cap_first}());
            }
        }
        List<${deMinApiCN}DTO> ${deMinApiCNLC}dtos2 = new ArrayList<${deapide.getCodeName()}DTO>();
        if (${deapide.getCodeName()?lower_case}dtos != null && ${deapide.getCodeName()?lower_case}dtos.size() > 0) {
            for (${deMinApiCN}DTO ${deapide.getCodeName()?lower_case}dto : ${deapide.getCodeName()?lower_case}dtos) {
                ${deapide.getCodeName()} ${deapide.getCodeName()?lower_case}Do = ${deapide.getCodeName()?lower_case}dto.toDO();
                ${deapide.getCodeName()?lower_case}Do.set${dePKCodeName?cap_first}(dto.get${dePKCodeName?cap_first}());
                if ( StringUtils.isEmpty( ${deapide.getCodeName()?lower_case}Do.get${deapide.getKeyPSDEField().getCodeName()?cap_first}()) || (${deMinApiCNLC}Ids != null && !${deMinApiCNLC}Ids.isEmpty() &&  ${deMinApiCNLC}Ids.contains(${deapide.getCodeName()?lower_case}Do.get${deapide.getKeyPSDEField().getCodeName()?cap_first}()))) {
                    ${deapide.getCodeName()?lower_case}Service.save(${deapide.getCodeName()?lower_case}Do);
                    ${deapide.getCodeName()?lower_case}dto.fromDO(${deapide.getCodeName()?lower_case}Do);
                    ${deapide.getCodeName()?lower_case}dtos2.add(${deapide.getCodeName()?lower_case}dto);
                } else {
                    ${deapide.getCodeName()?lower_case}Service.remove(${deapide.getCodeName()?lower_case}Do.get${deapide.getKeyPSDEField().getCodeName()?cap_first}());
                }
            }
        } else {
            ${deapide.getCodeName()?lower_case}dtos2 = ${deapide.getCodeName()?lower_case}dtos;
        }
        dto.set${subDTOs?cap_first}(${deapide.getCodeName()?lower_case}dtos2);

                            </#if>
                        </#list>
                    </#if>
        -->
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatch${byParams}", tags = {"${itemCodeName}" },  notes = "UpdateBatch${byParams}")
	@RequestMapping(method = RequestMethod.PUT, value = "${fullPath}/batch")
    public ResponseEntity<Boolean> updateBatch${byParams}(${etParamsList}) {
        List<${deCodeName}> domainlist=${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dtos);
        for(${deCodeName} domain:domainlist){
            ${parentSetParams}
        }
        ${deCodeNameLC}Service.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

                <#elseif deaction.codeName?lower_case == 'remove'>
    @ApiOperation(value = "${deaction.getLogicName()}${byParams}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}${byParams}")
	@RequestMapping(method = RequestMethod.DELETE, value = "${fullPath}/{${itemCodeNameLC + keyCNLC}}")
<#if de.getStorageMode()==4><#else>    @Transactional</#if>
    public ResponseEntity<Boolean> ${deactionCodeName?uncap_first}${byParams}(${idParams}) {
		return ResponseEntity.status(HttpStatus.OK).body(${deCodeNameLC}Service.remove(${itemCodeNameLC + keyCNLC}));
    }

    @ApiOperation(value = "RemoveBatch${byParams}", tags = {"${itemCodeName}" },  notes = "RemoveBatch${byParams}")
	@RequestMapping(method = RequestMethod.DELETE, value = "${fullPath}/batch")
    public ResponseEntity<Boolean> removeBatch${byParams}(@RequestBody List<${srfjavatype(de.getKeyPSDEField().getStdDataType())}> ids) {
        ${deCodeNameLC}Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

                <#elseif deaction.codeName?lower_case == 'save'>
    @ApiOperation(value = "${deaction.getLogicName()}${byParams}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}${byParams}")
	@RequestMapping(method = RequestMethod.${reqMtd}, value = "${fullPath}/${deactionCodeName?lower_case}")
    public ResponseEntity<Boolean> ${deactionCodeName?uncap_first}${byParams}(${etParams}) {
        ${deCodeName} domain = ${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dto);
        ${parentSetParams}
        return ResponseEntity.status(HttpStatus.OK).body(${deCodeNameLC}Service.save(domain));
    }

    @ApiOperation(value = "SaveBatch${byParams}", tags = {"${itemCodeName}" },  notes = "SaveBatch${byParams}")
	@RequestMapping(method = RequestMethod.POST, value = "${fullPath}/savebatch")
    public ResponseEntity<Boolean> saveBatch${byParams}(${etParamsList}) {
        List<${deCodeName}> domainlist=${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dtos);
        for(${deCodeName} domain:domainlist){
             ${parentSetParams}
        }
        ${deCodeNameLC}Service.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

                <#elseif deaction.codeName?lower_case == 'get'>
    @ApiOperation(value = "${deaction.getLogicName()}${byParams}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}${byParams}")
	@RequestMapping(method = RequestMethod.GET, value = "${fullPath}/{${itemCodeNameLC + keyCNLC}}")
    public ResponseEntity<${itemCodeName}DTO> ${deactionCodeName?uncap_first}${byParams}(${idParams}) {
        ${deCodeName} domain = ${deCodeNameLC}Service.get(${itemCodeNameLC + keyCNLC});
        ${itemCodeName}DTO dto = ${itemCodeNameLC}Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

               <#elseif deaction.codeName?lower_case == 'checkkey'>
    @ApiOperation(value = "${deaction.getLogicName()}${byParams}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}${byParams}")
	@RequestMapping(method = RequestMethod.${reqMtd}, value = "${fullPath}/${deactionCodeName?lower_case}")
    public ResponseEntity<Boolean> ${deactionCodeName?uncap_first}${byParams}(${etParams}) {
        return  ResponseEntity.status(HttpStatus.OK).body(${deCodeNameLC}Service.checkKey(${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dto)));
    }

                <#elseif deaction.codeName?lower_case == 'getdraft'>
    @ApiOperation(value = "${deaction.getLogicName()}${byParams}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}${byParams}")
    @RequestMapping(method = RequestMethod.${reqMtd}, value = "${fullPath}/${deactionCodeName?lower_case}")
    public ResponseEntity<${itemCodeName}DTO> ${deactionCodeName?uncap_first}${byParams}(${parentParams}) {
        ${deCodeName} domain = new ${deCodeName}();
        ${parentSetParams}
        return ResponseEntity.status(HttpStatus.OK).body(${itemCodeNameLC}Mapping.toDto(${deCodeNameLC}Service.getDraft(domain)));
    }

               <#elseif deaction.codeName?lower_case == 'createbatch'>
               <#elseif deaction.codeName?lower_case == 'updatebatch'>
               <#elseif deaction.codeName?lower_case == 'removebatch'>
               <#elseif deaction.codeName?lower_case == 'savebatch'>
               <#elseif deaction.getUserTag()?? && deaction.getActionType()?? && deaction.getUserTag() == 'REGIST' && deaction.getActionType() == 'USERCREATE'>
               <#else>
    @ApiOperation(value = "${deaction.getLogicName()}${byParams}", tags = {"${itemCodeName}" },  notes = "${deaction.getLogicName()}${byParams}")
	@RequestMapping(method = RequestMethod.${reqMtd}, value = "${fullPath}/{${itemCodeNameLC + dePKCodeNameLC}}/${deactionCodeName?lower_case}")
    <#if de.getStorageMode()==4><#else>    @Transactional</#if>
    public ResponseEntity<${itemCodeName}DTO> ${deactionCodeName?uncap_first}${byParams}(${id_etParams}) {
        ${deCodeName} domain = ${itemCodeNameLC}Mapping.toDomain(${itemCodeNameLC}dto);
        ${parentSetParams}
        domain = ${deCodeNameLC}Service.${srfmethodname(deactionCodeName)}(domain) ;
        ${itemCodeNameLC}dto = ${itemCodeNameLC}Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(${itemCodeNameLC}dto);
    }

               </#if>
            <#elseif apiMethod.getActionType()=='FETCH'>
                <#assign deds = apiMethod.getPSDEDataSet()>
	@ApiOperation(value = "fetch${deds.getLogicName()}${byParams}", tags = {"${itemCodeName}" } ,notes = "fetch${deds.getLogicName()}${byParams}")
    @RequestMapping(method= RequestMethod.${reqMtd} , value="${fullPath}/fetch<#if (deds.getName()=='DEFAULT')>${deds.getCodeName()?lower_case}<#else>${deds.getCodeName()?lower_case}</#if>")
	public ResponseEntity<List<<#if deds.isEnableGroup()>HashMap<#else>${itemCodeName}DTO</#if>>> fetch${itemCodeName}<#if (deds.getName()=='DEFAULT')>${deds.getCodeName()}<#else>${deds.getCodeName()}</#if>${byParams}(<#if parentParams!="">${parentParams},</#if>${deCodeName}SearchContext context) {
        ${parentSearchParams}
        <#if deds.isEnableGroup()>
        Page<HashMap> domains = ${deCodeNameLC}Service.search${deds.getCodeName()}(context) ;
	    return ResponseEntity.status(${statusCode})
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
        <#else>
        Page<${deCodeName}> domains = ${deCodeNameLC}Service.search${deds.getCodeName()}(context) ;
        List<${itemCodeName}DTO> list = ${itemCodeNameLC}Mapping.toDto(domains.getContent());
	    return ResponseEntity.status(${statusCode})
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
        </#if>
	}

	@ApiOperation(value = "search${deds.getLogicName()}${byParams}", tags = {"${itemCodeName}" } ,notes = "search${deds.getLogicName()}${byParams}")
    @RequestMapping(method= RequestMethod.${reqMtd} , value="${fullPath}/search<#if (deds.getName()=='DEFAULT')>${deds.getCodeName()?lower_case}<#else>${deds.getCodeName()?lower_case}</#if>")
	public ResponseEntity<Page<<#if deds.isEnableGroup()>HashMap<#else>${itemCodeName}DTO</#if>>> search${itemCodeName}<#if (deds.getName()=='DEFAULT')>${deds.getCodeName()}<#else>${deds.getCodeName()}</#if>${byParams}(<#if parentParams!="">${parentParams},</#if>${deCodeName}SearchContext context) {
        ${parentSearchParams}
        <#if deds.isEnableGroup()>
        Page<HashMap> domains = ${deCodeNameLC}Service.search${deds.getCodeName()}(context) ;
	    return ResponseEntity.status(${statusCode})
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
        <#else>
        Page<${deCodeName}> domains = ${deCodeNameLC}Service.search${deds.getCodeName()}(context) ;
	    return ResponseEntity.status(${statusCode})
                .body(new PageImpl(${itemCodeNameLC}Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
        </#if>
	}

            </#if>
        </#list>
    </#if>
    </#if>
  </#list>
</#if>
<#--  关系接口  end  -->

    /**
     * 用户权限校验
     * @return
     */
	public ${deCodeName} getEntity(){
        return new ${deCodeName}();
    }

}
</#if>
</#if>